@echo off
REM ---------------------------------------------------------------------------
REM
REM  Copyright (C) Intel Corporation, 2003 - 2006.
REM
REM  File:       checkca.bat
REM
REM  Contents:  batch file which checks for the existance of a subordinate
REM				Certificate Authority and creates one if necessary. 
REM
REM ----------------------------------------------------------------------------


REM ######################################################################
REM ###                                                                ###
REM ### This batch is called by the Configuration Server program        ###
REM ### in order to check if the subordinate CA is ready for use.      ###
REM ### you may customize this script and modify the defaults          ###
REM ### at your own risk.                                              ###
REM ###                                                                ###
REM ######################################################################

set exitCode=0

set PATH=%PATH%;../openSSL

:main

IF NOT EXIST "subCA" goto careq
IF NOT EXIST "subCA\subcacert.pem" goto casign

echo Check CA passed

goto end

:casign
echo Configuration server is missing a Subordinate CA certificate.
echo Please sign your certificate request, which is stored in the file 
echo "<Configuration Server Directory>\CertGenerator\SecScripts\subCA\certreq.pem" .
echo Save your signed request in X509 Base64 certificate in the file
echo "<Configuration Server Directory>\CertGenerator\SecScripts\subCA\subcacert.pem" 
echo Alternatively, you can generate a demo root CA and have it sign the request.
echo Creating a demo root CA should be done ONLY for test and demonstrational purposes !
set exitCode=2
yesno "Create a demo root CA and sign request [y/N] ?" N
IF NOT errorlevel 1 goto end
set exitCode=0
set CALLER_WAITS_ON_EXIT=1
call start /WAIT rootCA_gen.bat
call start /WAIT subCA_sign.bat
echo .
goto end


:careq
set exitCode=1
echo Configuration server can't run without a Subordinate CA configuration
yesno "Create a subordinate CA request file [Y/n] ?" Y
IF NOT errorlevel 1 goto end
set exitCode=0
set CALLER_WAITS_ON_EXIT=1
call start /WAIT subCA_req.bat
if NOT errorlevel 0 goto careq_err
echo Certificate request generated successfully
echo .
goto main

:careq_err
echo Failure while creating request file, aborting.
set exitCode=3
goto end


:end
exit %exitCode%
